<?php
/**
 * @file
 * Implements color module theme specific settings.
 */

// Pass some settings to JavaScript for the live preview.
drupal_add_js(array('color' => array('logo' => theme_get_setting('logo', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('header_bg_file' => theme_get_setting('header_bg_file', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('header_bg_alignment' => theme_get_setting('header_bg_alignment', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('header_watermark' => theme_get_setting('header_watermark', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('header_border_width' => theme_get_setting('header_border_width', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('layout_style' => theme_get_setting('layout_style', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('base_vmargin' => theme_get_setting('base_vmargin', 'mayo'))), 'setting');
drupal_add_js(array('color' => array('sb_layout_style' => theme_get_setting('sidebar_layout_style', 'mayo'))), 'setting');

$options = array('type' => 'file', 'group' => CSS_THEME, 'weight' => 10);

if (theme_get_setting('menubar_style', 'mayo') == 2) {
  drupal_add_css(drupal_get_path('theme', 'mayo') . '/css/black-menu.css', $options);
}
drupal_add_js(array('color' => array('menubar_style' => theme_get_setting('menubar_style', 'mayo'))), 'setting');

$round_corners = theme_get_setting('round_corners', 'mayo');
if ($round_corners == 1 || $round_corners == 3) {
  drupal_add_css(drupal_get_path('theme', 'mayo') . '/css/round-sidebar.css', $options);
}
if ($round_corners == 2 || $round_corners == 3) {
  drupal_add_css(drupal_get_path('theme', 'mayo') . '/css/round-node.css', $options);
}

$info = array(
  // Available colors and color labels used in theme.
  'fields' => array(
    'base' => t('Base background'),
    'bg' => t('Page background'),
    'left' => t('Header left'),
    'right' => t('Header right'),
    'headerborders' => t('Header borders'),
    'text' => t('Text color'),
    'link' => t('Link color'),
    'highlight' => t('Highlight color'),
    'pagetitle' => t('Page title background'),
    'pagetitletext' => t('Page title text color'),
    'menudivider' => t('Menu divider'),
    'node' => t('Node background'),
    'nodeborders' => t('Node borders'),
    'nodedivider' => t('Node divider'),
    'stickynode' => t('Sticky node background'),
    'tableheader' => t('Table header background'),
    'even' => t('Even row background'),
    'sidebar' => t('Sidebar background'),
    'sidebarborders' => t('Sidebar borders'),
    'sidebardivider' => t('Sidebar divider'),
    'sidebartext' => t('Sidebar text color'),
    'sidebarlink' => t('Sidebar link color'),
    'footer' => t('Footer background'),
    'footertext' => t('Footer text color'),
    'footerlink' => t('Footer link color'),
    'titleslogan' => t('Title and slogan'),
  ),
  // Pre-defined color schemes.
  'schemes' => array(
    'default' => array(
      'title' => t('Mayo (default)'),
      'colors' => array(
        'base' => '#9f8365',
        'bg' => '#fef8dd',
        'left' => '#f99301',
        'right' => '#ddff61',
        'headerborders' => '#fdf7dc',
        'text' => '#3b3b3b',
        'link' => '#739400',
        'highlight' => '#e7e3a6',
        'pagetitle' => '#94974e',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#e3ddb0',
        'node' => '#fefefe',
        'nodeborders' => '#ececec',
        'nodedivider' => '#b8c195',
        'stickynode' => '#e6fba7',
        'tableheader' => '#dbdeab',
        'even' => '#ebf0cc',
        'sidebar' => '#fdefaa',
        'sidebarborders' => '#fceea9',
        'sidebardivider' => '#dccf93',
        'sidebartext' => '#5a5a5a',
        'sidebarlink' => '#cb6806',
        'footer' => '#564939',
        'footertext' => '#cccccc',
        'footerlink' => '#f0cb00',
        'titleslogan' => '#fcfcfc',
      ),
    ),
    'whity' => array(
      'title' => t('Whity'),
      'colors' => array(
        'base' => '#ffffff',
        'bg' => '#ffffff',
        'left' => '#ffffff',
        'right' => '#ffffff',
        'headerborders' => '#ffffff',
        'text' => '#3b3b3b',
        'link' => '#b52e1c',
        'highlight' => '#dddddd',
        'pagetitle' => '#666666',
        'pagetitletext' => '#f0f0f0',
        'menudivider' => '#aaaaaa',
        'node' => '#ffffff',
        'nodeborders' => '#ffffff',
        'nodedivider' => '#cccccc',
        'stickynode' => '#f8f8f8',
        'tableheader' => '#d2d2d2',
        'even' => '#e8e8e8',
        'sidebar' => '#ffffff',
        'sidebarborders' => '#ffffff',
        'sidebardivider' => '#cccccc',
        'sidebartext' => '#444444',
        'sidebarlink' => '#a66c3a',
        'footer' => '#dddddd',
        'footertext' => '#333333',
        'footerlink' => '#b5703b',
        'titleslogan' => '#555555',
      ),
    ),
    'sepia' => array(
      'title' => t('Sepia'),
      'colors' => array(
        'base' => '#a79a86',
        'bg' => '#ffffff',
        'left' => '#886d49',
        'right' => '#b3ac8f',
        'headerborders' => '#ffffff',
        'text' => '#605f5c',
        'link' => '#9a6f13',
        'highlight' => '#dfddd8',
        'pagetitle' => '#8e8367',
        'pagetitletext' => '#efe8cd',
        'menudivider' => '#e5dec7',
        'node' => '#fefefe',
        'nodeborders' => '#e0ddd6',
        'nodedivider' => '#c3b898',
        'stickynode' => '#e7e3df',
        'tableheader' => '#c3bba2',
        'even' => '#f0f0f0',
        'sidebar' => '#e7e3df',
        'sidebarborders' => '#e7e3df',
        'sidebardivider' => '#ada585',
        'sidebartext' => '#59544a',
        'sidebarlink' => '#985901',
        'footer' => '#544e3b',
        'footertext' => '#dedac4',
        'footerlink' => '#c49821',
        'titleslogan' => '#e2dcd4',
      ),
    ),
    'paleblue' => array(
      'title' => t('Pale Blue'),
      'colors' => array(
        'base' => '#909dd0',
        'bg' => '#ffffff',
        'left' => '#384780',
        'right' => '#7d8fc5',
        'headerborders' => '#3e6993',
        'text' => '#3b3b3b',
        'link' => '#335cd1',
        'highlight' => '#d2dcf3',
        'pagetitle' => '#666666',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#b8b8b8',
        'node' => '#fefefe',
        'nodeborders' => '#dedede',
        'nodedivider' => '#dcdcdc',
        'stickynode' => '#e1e8f5',
        'tableheader' => '#d3dbe4',
        'even' => '#eaecff',
        'sidebar' => '#e1e8f5',
        'sidebarborders' => '#e1e8f5',
        'sidebardivider' => '#acb6cd',
        'sidebartext' => '#434343',
        'sidebarlink' => '#0f61a3',
        'footer' => '#303641',
        'footertext' => '#cccccc',
        'footerlink' => '#72a4fd',
        'titleslogan' => '#c9d8f3',
      ),
    ),
    'silver' => array(
      'title' => t('Silver'),
      'colors' => array(
        'base' => '#b5b5b5',
        'bg' => '#f0f0f0',
        'left' => '#f0f0f0',
        'right' => '#f0f0f0',
        'headerborders' => '#f0f0f0',
        'text' => '#4a4a4a',
        'link' => '#8d56cd',
        'highlight' => '#bfbfbf',
        'pagetitle' => '#909090',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#bfbfbf',
        'node' => '#ffffff',
        'nodeborders' => '#ffffff',
        'nodedivider' => '#bcbcbc',
        'stickynode' => '#ffffff',
        'tableheader' => '#c9c9c9',
        'even' => '#f0f0f0',
        'sidebar' => '#ffffff',
        'sidebarborders' => '#ffffff',
        'sidebardivider' => '#a8a8a8',
        'sidebartext' => '#5a5a5a',
        'sidebarlink' => '#bc49ba',
        'footer' => '#4a4a4a',
        'footertext' => '#e6e6e6',
        'footerlink' => '#eb94ea',
        'titleslogan' => '#797979',
      ),
    ),
    'moss' => array(
      'title' => t('Moss'),
      'colors' => array(
        'base' => '#9ba984',
        'bg' => '#ffffff',
        'left' => '#7f9c21',
        'right' => '#e1f3a0',
        'headerborders' => '#ffffff',
        'text' => '#3b3b3b',
        'link' => '#619f3c',
        'highlight' => '#e8f3d2',
        'pagetitle' => '#677750',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#bababa',
        'node' => '#ffffff',
        'nodeborders' => '#e6e6e6',
        'nodedivider' => '#bcbeb7',
        'stickynode' => '#edf0db',
        'tableheader' => '#dde4d3',
        'even' => '#f4fce6',
        'sidebar' => '#edf0db',
        'sidebarborders' => '#ffffff',
        'sidebardivider' => '#9eac77',
        'sidebartext' => '#5e6440',
        'sidebarlink' => '#97a805',
        'footer' => '#4b533c',
        'footertext' => '#e6e6e6',
        'footerlink' => '#a0f15b',
        'titleslogan' => '#ffffff',
      ),
    ),
    'teal' => array(
      'title' => t('Teal'),
      'colors' => array(
        'base' => '#84a99f',
        'bg' => '#ffffff',
        'left' => '#3cafa3',
        'right' => '#a4fff1',
        'headerborders' => '#ffffff',
        'text' => '#3b3b3b',
        'link' => '#268c6c',
        'highlight' => '#d2f3e7',
        'pagetitle' => '#5f9b8f',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#d2e4e2',
        'node' => '#ffffff',
        'nodeborders' => '#e6e6e6',
        'nodedivider' => '#b7bebc',
        'stickynode' => '#daf6f8',
        'tableheader' => '#bad4d1',
        'even' => '#e6fcf2',
        'sidebar' => '#d5f6e6',
        'sidebarborders' => '#ffffff',
        'sidebardivider' => '#adcdc1',
        'sidebartext' => '#5b5b5b',
        'sidebarlink' => '#0585a8',
        'footer' => '#3d5c54',
        'footertext' => '#e6e6e6',
        'footerlink' => '#5dead0',
        'titleslogan' => '#ffffff',
      ),
    ),
    'water' => array(
      'title' => t('Water'),
      'colors' => array(
        'base' => '#75c6ff',
        'bg' => '#ffffff',
        'left' => '#38a7ff',
        'right' => '#d2eefe',
        'headerborders' => '#ffffff',
        'text' => '#424242',
        'link' => '#0185e4',
        'highlight' => '#d0e3f6',
        'pagetitle' => '#44a8f8',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#d2d2d2',
        'node' => '#ffffff',
        'nodeborders' => '#e0e0e0',
        'nodedivider' => '#aac6d5',
        'stickynode' => '#e1f0ff',
        'tableheader' => '#a8d5f5',
        'even' => '#e8f3fd',
        'sidebar' => '#d7ebff',
        'sidebarborders' => '#d7ebff',
        'sidebardivider' => '#a9c0d6',
        'sidebartext' => '#616161',
        'sidebarlink' => '#2a7ffe',
        'footer' => '#323e4d',
        'footertext' => '#c6e0f0',
        'footerlink' => '#52a6ff',
        'titleslogan' => '#ffffff',
      ),
    ),
    'bluesky' => array(
      'title' => t('Blue Sky'),
      'colors' => array(
        'base' => '#396ec6',
        'bg' => '#ffffff',
        'left' => '#0044d6',
        'right' => '#9ed1ff',
        'headerborders' => '#ffffff',
        'text' => '#424242',
        'link' => '#1a7def',
        'highlight' => '#d0e3f6',
        'pagetitle' => '#2f5ec1',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#bcbcbc',
        'node' => '#ffffff',
        'nodeborders' => '#ffffff',
        'nodedivider' => '#b8bcbe',
        'stickynode' => '#d7dfff',
        'tableheader' => '#c0dbfb',
        'even' => '#e6eafa',
        'sidebar' => '#d7dfff',
        'sidebarborders' => '#d7dfff',
        'sidebardivider' => '#a9b2d6',
        'sidebartext' => '#404b64',
        'sidebarlink' => '#3b92bc',
        'footer' => '#2d355c',
        'footertext' => '#e5e5e5',
        'footerlink' => '#5291ff',
        'titleslogan' => '#ffffff',
      ),
    ),
    'violet' => array(
      'title' => t('Violet'),
      'colors' => array(
        'base' => '#9975c2',
        'bg' => '#ffffff',
        'left' => '#763dfa',
        'right' => '#d986fd',
        'headerborders' => '#ffffff',
        'text' => '#3c3843',
        'link' => '#aa3eda',
        'highlight' => '#ded2f3',
        'pagetitle' => '#956de9',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#d4c3ef',
        'node' => '#ffffff',
        'nodeborders' => '#d9cde9',
        'nodedivider' => '#d4c3e9',
        'stickynode' => '#f2ecf8',
        'tableheader' => '#d4c8f3',
        'even' => '#f0e8ff',
        'sidebar' => '#f2ecf8',
        'sidebarborders' => '#ffffff',
        'sidebardivider' => '#e0d1f5',
        'sidebartext' => '#8c73a5',
        'sidebarlink' => '#6a29ef',
        'footer' => '#271e3e',
        'footertext' => '#ddd5ec',
        'footerlink' => '#a972fd',
        'titleslogan' => '#ffffff',
      ),
    ),
    'orange' => array(
      'title' => t('Orange'),
      'colors' => array(
        'base' => '#ffa30f',
        'bg' => '#fff1d6',
        'left' => '#fa5f3d',
        'right' => '#ffe824',
        'headerborders' => '#fff1d6',
        'text' => '#685c4a',
        'link' => '#b34f32',
        'highlight' => '#e3a968',
        'pagetitle' => '#fc6d22',
        'pagetitletext' => '#fffde8',
        'menudivider' => '#edddc9',
        'node' => '#ffffff',
        'nodeborders' => '#f5ede0',
        'nodedivider' => '#e2ccab',
        'stickynode' => '#ffdea8',
        'tableheader' => '#f8c88c',
        'even' => '#f7ecde',
        'sidebar' => '#ffdea8',
        'sidebarborders' => '#ffdea8',
        'sidebardivider' => '#e5be8b',
        'sidebartext' => '#8a6e56',
        'sidebarlink' => '#f8761b',
        'footer' => '#7a4001',
        'footertext' => '#e5ddca',
        'footerlink' => '#ff7505',
        'titleslogan' => '#ffffff',
      ),
    ),
    'mocha' => array(
      'title' => t('Mocha'),
      'colors' => array(
        'base' => '#70522e',
        'bg' => '#e4cfaa',
        'left' => '#c9a96e',
        'right' => '#d4ba8c',
        'headerborders' => '#e4cfaa',
        'text' => '#534336',
        'link' => '#975b1c',
        'highlight' => '#f3e4be',
        'pagetitle' => '#90705a',
        'pagetitletext' => '#f1f0e8',
        'menudivider' => '#c2ac7a',
        'node' => '#fff5d6',
        'nodeborders' => '#fff5d6',
        'nodedivider' => '#cbb59a',
        'stickynode' => '#feea9a',
        'tableheader' => '#cbb18b',
        'even' => '#e3d7c0',
        'sidebar' => '#f6e1b7',
        'sidebarborders' => '#f8e7c4',
        'sidebardivider' => '#ccb08e',
        'sidebartext' => '#615342',
        'sidebarlink' => '#c55b34',
        'footer' => '#4d3d2e',
        'footertext' => '#f0e2bc',
        'footerlink' => '#d48f2b',
        'titleslogan' => '#7f5f3d',
      ),
    ),
    'tricolor' => array(
      'title' => t('Tricolor'),
      'colors' => array(
        'base' => '#a2a2a2',
        'bg' => '#ffffff',
        'left' => '#e00012',
        'right' => '#1a61ff',
        'headerborders' => '#ffffff',
        'text' => '#3b3b3b',
        'link' => '#2c4ce4',
        'highlight' => '#d4dcf2',
        'pagetitle' => '#eb4c53',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#b3bccc',
        'node' => '#ffffff',
        'nodeborders' => '#ffffff',
        'nodedivider' => '#b0c1e8',
        'stickynode' => '#f8d8d8',
        'tableheader' => '#dfe1f4',
        'even' => '#ffeaf4',
        'sidebar' => '#f8d8d8',
        'sidebarborders' => '#f6cbcb',
        'sidebardivider' => '#e6b3b3',
        'sidebartext' => '#5e2d2b',
        'sidebarlink' => '#df2a2c',
        'footer' => '#003b9e',
        'footertext' => '#dedad8',
        'footerlink' => '#ff0f17',
        'titleslogan' => '#ffffff',
      ),
    ),
    'oldfashion' => array(
      'title' => t('Old Fashion'),
      'colors' => array(
        'base' => '#5c5c5c',
        'bg' => '#ffffff',
        'left' => '#b0b0b0',
        'right' => '#dedede',
        'headerborders' => '#6b6b6b',
        'text' => '#3b3b3b',
        'link' => '#8a5014',
        'highlight' => '#cfcfcf',
        'pagetitle' => '#5e5e5e',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#b8b8b8',
        'node' => '#ffffff',
        'nodeborders' => '#b8b8b8',
        'nodedivider' => '#c2c2c2',
        'stickynode' => '#ebebeb',
        'tableheader' => '#d1d1d1',
        'even' => '#f4f4f4',
        'sidebar' => '#ebebeb',
        'sidebarborders' => '#929292',
        'sidebardivider' => '#a1a1a1',
        'sidebartext' => '#505050',
        'sidebarlink' => '#ae7029',
        'footer' => '#3a3a3a',
        'footertext' => '#ebebeb',
        'footerlink' => '#c8a37e',
        'titleslogan' => '#404040',
      ),
    ),
    'candy' => array(
      'title' => t('Candy'),
      'colors' => array(
        'base' => '#d16677',
        'bg' => '#e6c9b2',
        'left' => '#ff9557',
        'right' => '#f7d150',
        'headerborders' => '#e6c9b2',
        'text' => '#4c452f',
        'link' => '#964edf',
        'highlight' => '#c6aa86',
        'pagetitle' => '#bf58e4',
        'pagetitletext' => '#ffffff',
        'menudivider' => '#d2ac9d',
        'node' => '#fdf6d3',
        'nodeborders' => '#fdf6d3',
        'nodedivider' => '#c7bf8e',
        'stickynode' => '#fcd5f6',
        'tableheader' => '#eed886',
        'even' => '#f4e5b8',
        'sidebar' => '#fcd5f6',
        'sidebarborders' => '#fdbef4',
        'sidebardivider' => '#dca8e1',
        'sidebartext' => '#7b5181',
        'sidebarlink' => '#f93edc',
        'footer' => '#622e2d',
        'footertext' => '#d6d6d6',
        'footerlink' => '#e4bc01',
        'titleslogan' => '#9205ff',
      ),
    ),
    'emerald' => array(
      'title' => t('Emerald'),
      'colors' => array(
        'base' => '#0a8577',
        'bg' => '#c3feef',
        'left' => '#009493',
        'right' => '#d6ff24',
        'headerborders' => '#c3feef',
        'text' => '#495555',
        'link' => '#008bb8',
        'highlight' => '#73d4bd',
        'pagetitle' => '#1f9892',
        'pagetitletext' => '#e8fffd',
        'menudivider' => '#a1d9c8',
        'node' => '#ffffff',
        'nodeborders' => '#cae8e1',
        'nodedivider' => '#b0d9d2',
        'stickynode' => '#7fd7cd',
        'tableheader' => '#81dac1',
        'even' => '#edfcf8',
        'sidebar' => '#7fd7cd',
        'sidebarborders' => '#6dd5c9',
        'sidebardivider' => '#6ab4ac',
        'sidebartext' => '#316d69',
        'sidebarlink' => '#0271e8',
        'footer' => '#0f484d',
        'footertext' => '#cae5de',
        'footerlink' => '#33d0e6',
        'titleslogan' => '#ffffff',
      ),
    ),
    'earth' => array(
      'title' => t('Earth'),
      'colors' => array(
        'base' => '#af9d6a',
        'bg' => '#fcf7ee',
        'left' => '#b2925c',
        'right' => '#7b634c',
        'headerborders' => '#ffffff',
        'text' => '#534336',
        'link' => '#5a971c',
        'highlight' => '#e8dfcf',
        'pagetitle' => '#83766d',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#d7d4cb',
        'node' => '#fffefb',
        'nodeborders' => '#e3e0d9',
        'nodedivider' => '#b9bfa1',
        'stickynode' => '#ebe5d5',
        'tableheader' => '#dbd4bd',
        'even' => '#f2efe3',
        'sidebar' => '#ebe5d5',
        'sidebarborders' => '#ebe5d5',
        'sidebardivider' => '#c1a695',
        'sidebartext' => '#615342',
        'sidebarlink' => '#c55b34',
        'footer' => '#403530',
        'footertext' => '#e8e8e8',
        'footerlink' => '#efb82a',
        'titleslogan' => '#ffffff',
      ),
    ),
    'camel' => array(
      'title' => t('Camel'),
      'colors' => array(
        'base' => '#b08e54',
        'bg' => '#f4e3ae',
        'left' => '#c88d2d',
        'right' => '#ab792b',
        'headerborders' => '#f4e3ae',
        'text' => '#4f3926',
        'link' => '#ad5d25',
        'highlight' => '#d3be97',
        'pagetitle' => '#765d42',
        'pagetitletext' => '#ffe085',
        'menudivider' => '#d9c178',
        'node' => '#f4e9c3',
        'nodeborders' => '#edda96',
        'nodedivider' => '#c7a357',
        'stickynode' => '#dfce9f',
        'tableheader' => '#d8bd8d',
        'even' => '#eadba9',
        'sidebar' => '#e8d18d',
        'sidebarborders' => '#e8d18d',
        'sidebardivider' => '#c1aa8a',
        'sidebartext' => '#704f2e',
        'sidebarlink' => '#de8121',
        'footer' => '#453427',
        'footertext' => '#d7c6b7',
        'footerlink' => '#b18035',
        'titleslogan' => '#fed06d',
      ),
    ),
    'azuki' => array(
      'title' => t('Azuki'),
      'colors' => array(
        'base' => '#623e3c',
        'bg' => '#ae7a7a',
        'left' => '#75292f',
        'right' => '#edc5c8',
        'headerborders' => '#ad7171',
        'text' => '#444341',
        'link' => '#a02c49',
        'highlight' => '#c8a2a2',
        'pagetitle' => '#864441',
        'pagetitletext' => '#f0d2cb',
        'menudivider' => '#985a52',
        'node' => '#fbf4f4',
        'nodeborders' => '#f6e5e5',
        'nodedivider' => '#d4b8b5',
        'stickynode' => '#c89893',
        'tableheader' => '#e8cbca',
        'even' => '#eedddd',
        'sidebar' => '#c89893',
        'sidebarborders' => '#c89893',
        'sidebardivider' => '#deb1af',
        'sidebartext' => '#594e4a',
        'sidebarlink' => '#d52401',
        'footer' => '#442e2c',
        'footertext' => '#dedad8',
        'footerlink' => '#fa6166',
        'titleslogan' => '#ebc8c6',
      ),
    ),
    'pink' => array(
      'title' => t('Pink'),
      'colors' => array(
        'base' => '#fec2f9',
        'bg' => '#ffe6fd',
        'left' => '#e75fde',
        'right' => '#e444bb',
        'headerborders' => '#e854d4',
        'text' => '#3b3b3b',
        'link' => '#d55876',
        'highlight' => '#e0c2dd',
        'pagetitle' => '#a65993',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#d1a3c8',
        'node' => '#fefefe',
        'nodeborders' => '#edd9e9',
        'nodedivider' => '#d2a3c9',
        'stickynode' => '#ffccf4',
        'tableheader' => '#e9c3e3',
        'even' => '#f7e7f8',
        'sidebar' => '#ffccf4',
        'sidebarborders' => '#f8c6ec',
        'sidebardivider' => '#c181b0',
        'sidebartext' => '#747474',
        'sidebarlink' => '#b21580',
        'footer' => '#6a4d64',
        'footertext' => '#cccccc',
        'footerlink' => '#f943db',
        'titleslogan' => '#ffffff',
      ),
    ),
    'blue' => array(
      'title' => t('Blue'),
      'colors' => array(
        'base' => '#3753ae',
        'bg' => '#7ea6fb',
        'left' => '#04206c',
        'right' => '#2c64fc',
        'headerborders' => '#7ea6fb',
        'text' => '#3b3b3b',
        'link' => '#1948d2',
        'highlight' => '#a8bdeb',
        'pagetitle' => '#3a51a1',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#689add',
        'node' => '#d1deff',
        'nodeborders' => '#f0f4ff',
        'nodedivider' => '#869bca',
        'stickynode' => '#a8c2ff',
        'tableheader' => '#5385df',
        'even' => '#b8caf9',
        'sidebar' => '#a8c2ff',
        'sidebarborders' => '#bdd0ff',
        'sidebardivider' => '#8199ca',
        'sidebartext' => '#434343',
        'sidebarlink' => '#0f71ff',
        'footer' => '#232f61',
        'footertext' => '#cccccc',
        'footerlink' => '#78adfc',
        'titleslogan' => '#ffffff',
      ),
    ),
    'green' => array(
      'title' => t('Green'),
      'colors' => array(
        'base' => '#3e5b3f',
        'bg' => '#a7db9f',
        'left' => '#065b26',
        'right' => '#a0fb9d',
        'headerborders' => '#a7db9f',
        'text' => '#3b3b3b',
        'link' => '#4d8628',
        'highlight' => '#82c87e',
        'pagetitle' => '#44a13a',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#88b785',
        'node' => '#e2ffd7',
        'nodeborders' => '#f3fff0',
        'nodedivider' => '#8bca86',
        'stickynode' => '#cdf9c3',
        'tableheader' => '#65b367',
        'even' => '#caf6b7',
        'sidebar' => '#cdf9c3',
        'sidebarborders' => '#d6fad1',
        'sidebardivider' => '#93c899',
        'sidebartext' => '#434343',
        'sidebarlink' => '#52a800',
        'footer' => '#1f4722',
        'footertext' => '#c0cbbe',
        'footerlink' => '#d7fc78',
        'titleslogan' => '#ffffff',
      ),
    ),
    'strawberry' => array(
      'title' => t('Strawberry'),
      'colors' => array(
        'base' => '#c6393b',
        'bg' => '#f4b3b7',
        'left' => '#a20f02',
        'right' => '#fd8788',
        'headerborders' => '#f4b3b7',
        'text' => '#3b3b3b',
        'link' => '#af1d27',
        'highlight' => '#d48c8d',
        'pagetitle' => '#be4c30',
        'pagetitletext' => '#f1f1f1',
        'menudivider' => '#c89589',
        'node' => '#fed8d7',
        'nodeborders' => '#ffdcdc',
        'nodedivider' => '#ca868b',
        'stickynode' => '#ee9691',
        'tableheader' => '#cc7461',
        'even' => '#f8c5c3',
        'sidebar' => '#ee9691',
        'sidebarborders' => '#e58f8b',
        'sidebardivider' => '#cb7867',
        'sidebartext' => '#434343',
        'sidebarlink' => '#d92902',
        'footer' => '#6d2b1c',
        'footertext' => '#e5d6d0',
        'footerlink' => '#fca67a',
        'titleslogan' => '#fec2b9',
      ),
    ),
    'darkolive' => array(
      'title' => t('Dark Olive'),
      'colors' => array(
        'base' => '#61604c',
        'bg' => '#353131',
        'left' => '#242323',
        'right' => '#242323',
        'headerborders' => '#353635',
        'text' => '#b8b7b7',
        'link' => '#6f9d1b',
        'highlight' => '#21231f',
        'pagetitle' => '#625750',
        'pagetitletext' => '#c8c9c0',
        'menudivider' => '#494a45',
        'node' => '#44423c',
        'nodeborders' => '#4d4b42',
        'nodedivider' => '#333129',
        'stickynode' => '#424242',
        'tableheader' => '#4f4c40',
        'even' => '#4a483f',
        'sidebar' => '#424242',
        'sidebarborders' => '#474747',
        'sidebardivider' => '#2c2c2c',
        'sidebartext' => '#aaaba6',
        'sidebarlink' => '#c86828',
        'footer' => '#222120',
        'footertext' => '#e0e0e0',
        'footerlink' => '#efb82a',
        'titleslogan' => '#dfaa16',
      ),
    ),
    'chocolate' => array(
      'title' => t('Chocolate'),
      'colors' => array(
        'base' => '#060500',
        'bg' => '#292119',
        'left' => '#251f18',
        'right' => '#1f1a14',
        'headerborders' => '#211712',
        'text' => '#b89f89',
        'link' => '#9d3e1b',
        'highlight' => '#443a2c',
        'pagetitle' => '#523c2e',
        'pagetitletext' => '#c2894c',
        'menudivider' => '#47341a',
        'node' => '#352b21',
        'nodeborders' => '#352b21',
        'nodedivider' => '#5a4a3a',
        'stickynode' => '#352b21',
        'tableheader' => '#483a2d',
        'even' => '#3d2f24',
        'sidebar' => '#352b21',
        'sidebarborders' => '#352b21',
        'sidebardivider' => '#5a463f',
        'sidebartext' => '#b1a595',
        'sidebarlink' => '#c48f45',
        'footer' => '#1b1917',
        'footertext' => '#b4a09c',
        'footerlink' => '#ab7a26',
        'titleslogan' => '#824c27',
      ),
    ),
    'deepocean' => array(
      'title' => t('Deep Ocean'),
      'colors' => array(
        'base' => '#202432',
        'bg' => '#2d3448',
        'left' => '#364159',
        'right' => '#1d5191',
        'headerborders' => '#3c4962',
        'text' => '#b9c5da',
        'link' => '#337bff',
        'highlight' => '#1d1f25',
        'pagetitle' => '#516585',
        'pagetitletext' => '#9dc6f0',
        'menudivider' => '#39465b',
        'node' => '#364054',
        'nodeborders' => '#424a62',
        'nodedivider' => '#4f628c',
        'stickynode' => '#344160',
        'tableheader' => '#46516d',
        'even' => '#3d4961',
        'sidebar' => '#344160',
        'sidebarborders' => '#425078',
        'sidebardivider' => '#5d6c88',
        'sidebartext' => '#879ac4',
        'sidebarlink' => '#1febff',
        'footer' => '#212530',
        'footertext' => '#858fa7',
        'footerlink' => '#72a4fd',
        'titleslogan' => '#38bbff',
      ),
    ),
    'forest' => array(
      'title' => t('Forest'),
      'colors' => array(
        'base' => '#161a12',
        'bg' => '#252f1d',
        'left' => '#16200e',
        'right' => '#3c5c1e',
        'headerborders' => '#405034',
        'text' => '#b5c8a3',
        'link' => '#5dac06',
        'highlight' => '#3a503a',
        'pagetitle' => '#3c4635',
        'pagetitletext' => '#7b9c77',
        'menudivider' => '#434e41',
        'node' => '#2a3521',
        'nodeborders' => '#2c3723',
        'nodedivider' => '#23281f',
        'stickynode' => '#2a3829',
        'tableheader' => '#43513e',
        'even' => '#333e28',
        'sidebar' => '#2a3829',
        'sidebarborders' => '#2f3e2e',
        'sidebardivider' => '#1e291f',
        'sidebartext' => '#8ab28e',
        'sidebarlink' => '#adb545',
        'footer' => '#1c2117',
        'footertext' => '#8a9b78',
        'footerlink' => '#81e713',
        'titleslogan' => '#9cbc52',
      ),
    ),
    'sunset' => array(
      'title' => t('Sunset'),
      'colors' => array(
        'base' => '#a34000',
        'bg' => '#131111',
        'left' => '#fdb34e',
        'right' => '#ca4f02',
        'headerborders' => '#000000',
        'text' => '#c4b378',
        'link' => '#c36328',
        'highlight' => '#3b2508',
        'pagetitle' => '#4d2705',
        'pagetitletext' => '#c69b2f',
        'menudivider' => '#2e1d10',
        'node' => '#171715',
        'nodeborders' => '#000000',
        'nodedivider' => '#b27334',
        'stickynode' => '#141413',
        'tableheader' => '#744c25',
        'even' => '#21201c',
        'sidebar' => '#141413',
        'sidebarborders' => '#000000',
        'sidebardivider' => '#793a01',
        'sidebartext' => '#6b413d',
        'sidebarlink' => '#db7329',
        'footer' => '#2b180d',
        'footertext' => '#be926a',
        'footerlink' => '#f0bc00',
        'titleslogan' => '#853800',
      ),
    ),
    'neon' => array(
      'title' => t('Neon'),
      'colors' => array(
        'base' => '#000000',
        'bg' => '#16161d',
        'left' => '#1d1b23',
        'right' => '#3b0fb8',
        'headerborders' => '#6e13ec',
        'text' => '#9a9a9a',
        'link' => '#9552ff',
        'highlight' => '#040307',
        'pagetitle' => '#35284d',
        'pagetitletext' => '#ffbc85',
        'menudivider' => '#2f293d',
        'node' => '#16161d',
        'nodeborders' => '#261645',
        'nodedivider' => '#37226d',
        'stickynode' => '#16141a',
        'tableheader' => '#4f367d',
        'even' => '#1f1f28',
        'sidebar' => '#16141a',
        'sidebarborders' => '#5c39f3',
        'sidebardivider' => '#40298e',
        'sidebartext' => '#aaaab6',
        'sidebarlink' => '#da34cb',
        'footer' => '#0e0d12',
        'footertext' => '#c9a8d6',
        'footerlink' => '#ef6f2a',
        'titleslogan' => '#d6c50a',
      ),
    ),
  ),

  // CSS files (excluding @import) to rewrite with new color scheme.
  'css' => array(
    'css/colors.css',
  ),

  // Files to copy.
  'copy' => array(
    'logo.png',
  ),

  // Gradient definitions.
  'gradients' => array(
    array(
      // (x, y, width, height).
      'dimension' => array(0, 0, 0, 0),
      // Direction of gradient ('vertical' or 'horizontal').
      'direction' => 'horizontal',
      // Keys of colors to use for the gradient.
      'colors' => array('left', 'right'),
    ),
  ),

  // Color areas to fill (x, y, width, height).
  'fill' => array(),

  // Coordinates of all the theme slices (x, y, width, height)
  // with their filename as used in the stylesheet.
  'slices' => array(),

  // Reference color used for blending. Matches the base.png's colors.
  'blend_target' => '#ffffff',

  // Preview files.
  'preview_css' => 'color/preview.css',
  'preview_js' => 'color/preview.js',
  'preview_html' => 'color/preview.html',

  // Base file for image generation.
  'base_image' => 'color/base.png',
);
